        #include <gb.h>
#include "data.h"
#include "menu.h"
#include "sendcmd.h"
#include "gbsup.h"

#define PhysAddr(a) (CurrAddr[a]+(a*64))

static UBYTE data[16][16];
static UBYTE CurrAddr[MS_NSTATES];
static UBYTE SystemState;

UBYTE InitData(void)
{
  UWORD i;
  for(i=0; i<MS_NSTATES; i++) CurrAddr[i]=0;
  for(i=  0; i< 64; i++) data[i/16][i%16]=0;
  for(i= 64; i<128; i++) data[i/16][i%16]=128;
  for(i=128; i<192; i++) data[i/16][i%16]=128;
  for(i=192; i<256; i++) data[i/16][i%16]=0;
  SetSysRun();
  return 0;               
}

UBYTE SetSysRun( void )
{
  return SystemState = SYS_RUN;
}

UBYTE SetSysRst( void )
{
  return SystemState = SYS_RST;
}

UBYTE SysState( void )
{
  return SystemState;
}

UBYTE IncAddr( UBYTE a )
{
  switch(a)
  {
     case 0:
     case 1:
     case 2:
       if( CurrAddr[a] < 63 ) CurrAddr[a]++;
     break;
     case 3:
       if( CurrAddr[a] < 62 ) CurrAddr[a]++;
     break;
  }
  return CurrAddr[a];
}

UBYTE DecAddr( UBYTE a )
{
  if( CurrAddr[a] > 0 ) CurrAddr[a]--;
  return CurrAddr[a];
}

UBYTE SubAddr( UBYTE a, UBYTE d )
{
  if( CurrAddr[a] >= d ) CurrAddr[a]-=d;
  return CurrAddr[a];
}

UBYTE AddAddr( UBYTE a, UBYTE d )
{
  switch(a)
  {
    case 0:
    case 1:
    case 2:
      if( CurrAddr[a] <= (63-d) ) CurrAddr[a]+=d;
    break;
    case 3:
      if( CurrAddr[a] <= (62-d) ) CurrAddr[a]+=d;
    break;
  }
  return CurrAddr[a];
}

UBYTE IncData( UBYTE a )
{
  UBYTE x, d;
  x=PhysAddr(a);
  d=data[x/16][x%16];
  switch(a)
  {
    case MS_LOCO:
      if( d==0x40 )
        d=0x80;
      else
      {
        if( (d>=0x80) && (d<=158) ) d++;
        if( (d>0x40) && (d<=95) ) d--;
      }
    break;
  }
  data[x/16][x%16]=d;
  SendPacket(a);
  if( d==0x40 )
    return 255;
  else
    return 0;
}

UBYTE DecData( UBYTE a )
{
  UBYTE x, d;
  x=PhysAddr(a);
  d=data[x/16][x%16];
  switch(a)
  {
    case MS_LOCO:
      if( d==0x80 )
        d=0x40;
      else
      {
        if( (d>0x80) && (d<=159) ) d--;
        if( (d>=0x40) && (d<=94) ) d++;
      }
    break;
  }
  data[x/16][x%16]=d;
  SendPacket(a);
  if( d==0x80 )
    return 255;
  else
    return 0;
}

UBYTE GetAddr( UBYTE a )
{
  return CurrAddr[a];
}

UBYTE GetPhysAddr( UBYTE a )
{
  return PhysAddr(a);
}

UBYTE GetData( UBYTE a )
{
  UBYTE x;
  x=PhysAddr(a);
  return data[x/16][x%16];
}

UBYTE SetData( UBYTE a, UBYTE d )
{
  UBYTE x;
  x=PhysAddr(a);
  data[x/16][x%16]=d;
  SendPacket(a);
  return d;
}

UBYTE SwitchData( UBYTE a )
{
  if( GetData(a)==0x40 )
  {
    SetData( a, 159 );
    WaitKeyRelease();
    SetData( a, 0x80 );
  }
  else
  {
    SetData( a, 95 );
    WaitKeyRelease();
    SetData( a, 0x40 );
  }
  return GetData(a);
}

UBYTE LampData( UBYTE a )
{
  if( GetData(a)==0 )
    SetData( a, 159 );
  else
    SetData( a, 0 );
  return GetData(a);
}
  
UBYTE SendPacket( UBYTE a )
{
  SendCmd( GetPhysAddr(a), GetData(a), SCP_LOW );
  return 0;
}
                       







